IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[dbo].[CP_DB_Table_BackUp]') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE dbo.CP_DB_Table_BackUp 
END
GO


CREATE PROCEDURE dbo.CP_DB_Table_BackUp @Tabla VARCHAR(128)
AS 
DECLARE @Nombre			VARCHAR(255)
DECLARE @Sql			VARCHAR(8000)
DECLARE @Mensaje		VARCHAR(100)
DECLARE @ErrorLine		INT
DECLARE @ErrorNumber	INT

BEGIN TRY
	BEGIN TRAN

	SET @Nombre = 'z_'+ @Tabla +'_'+ 
					convert(varchar(19),GETDATE(),12) +'_' + 
					SUBSTRING(convert(varchar(19),GETDATE(),108),1,2) +
					SUBSTRING(convert(varchar(19),GETDATE(),108),4,2) +
					SUBSTRING(convert(varchar(19),GETDATE(),108),7,2) 
	--select * INTO  CAST(@Nombre AS sysname) FROM @Tabla

	SET @Sql = 'SELECT * INTO '+ @Nombre  + ' FROM '+ @Tabla
	EXECUTE (@Sql)

    COMMIT
	SET @ErrorNumber = 0 
	SET @ErrorLine = 0
	SET @Mensaje = 'Table '+ @Nombre + ' created.'

	SELECT	 @ErrorNumber	AS ErrorNumber 
			,0				AS ErrorSeverity  
			,0				AS ErrorState 
			,0				AS ErrorProcedure  
			,@ErrorLine		AS ErrorLine		
			,@Mensaje		AS ErrorMessage

END TRY  


BEGIN CATCH  
    EXECUTE usp_GetErrorInfo;  
	ROLLBACK
END CATCH;  
